%% parameter
nf = 22;
%% first figure
sp = regionprops(BW);
figure(1)
imshow(BW)
hold on
plot(sp.Centroid(1),sp.Centroid(2),'xr')
plot(cell(1,1:nf),cell(2,1:nf),'o-c')
plot(golgi(1,1:nf),golgi(2,1:nf),'o-g')
nuc = [];
for i=1:nf
    nuc = [nuc;stats(i).Centroid(:)'] ;
end
nuc =nuc';
plot(nuc(2,1:nf),nuc(1,1:nf),'o-r')
%% plots angles as a function of time
for i=1:nf
   ac(i) = atan2(cell(2,i)-sp.Centroid(2),cell(1,i)-sp.Centroid(1)); 
   ag(i) = atan2(golgi(2,i)-sp.Centroid(2),golgi(1,i)-sp.Centroid(1)); 
   an(i) = atan2(nuc(1,i)-sp.Centroid(2),nuc(2,i)-sp.Centroid(1)); 
   agn(i) = atan2(golgi(2,i)-nuc(1,i),golgi(1,i)-nuc(2,i)); 
   dc(i) = sqrt((cell(2,i)-sp.Centroid(2))^2+(cell(1,i)-sp.Centroid(1))^2); 
   dn(i) = sqrt((nuc(1,i)-sp.Centroid(2))^2+(nuc(2,i)-sp.Centroid(1))^2);
end
% figure(2)
% hold on
% plot([1:nf],radtodeg(ac),'c')
% plot([1:nf],radtodeg(ag),'g')
% plot([1:nf],radtodeg(agn),'r')
% figure(3)
% hold on
% plot([1:nf],dc,'--c')
% plot([1:nf],dn,'--g')
%% figure with only golgi-nucleus axis
mymap = zeros(nf,3);
R = linspace(0,1,nf);
B = linspace(1,0,nf);
mymap(:,1)=R;
mymap(:,3)=B;
figure(1)
imshow(BW)
hold on
for i=1:nf
   plot([golgi(1,i),nuc(2,i)],[golgi(2,i),nuc(1,i)],'color',mymap(i,:),'linewidth',3);
end